<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Company extends Model
{
    protected $guarded = ['id'];

    public function notes(){
        return $this->hasMany('App\CompanyNote');
    }

    public function sites(){
        return $this->hasMany('App\Site');
    }

    public function equipments(){
        return $this->belongsToMany('App\Equipment');
    }

    public function contactPeople(){
        return $this->belongsToMany('App\ContactPeople', 'company_contact', 'company_id', 'contactperson_id');
    }

    public function request() {
        return $this->hasMany('App\JobRequest', 'company_id');
    }
}
