<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class HoursReport extends Model
{
    protected $table = 'hours_reports';
    protected $guarded = ['id'];

    public function hours_report_desc(){
        return $this->hasOne(HoursReportDesc::class);
    }

    public function job_expenses(){
        return $this->hasOne(JobExpenses::class);
    }

    public function timesheet(){
        return $this->hasOne(TimeSheet::class);
    }

    public function job_request(){
        return $this->belongsTo(JobRequest::class, 'request_id');
    }


}
