<?php

namespace App\Http\Controllers;

use App\Company;
use App\CompanyNote;
use Log;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class CompaniesController extends Controller
{

    public function index()
    {
         $companies = Cache::remember('companies', 23*60, function (){
             return Company::latest()->get();
         });

        return response()->json($companies, 200);
    }

    public function getCompanies(){
        $companies = collect( Company::all())->pluck('company_name', 'id');
        return response()->json($companies->all(), 200);
    }

    public function create(Request $request)
    {
        $company = Company::create($request->all());
        return response()->json($company, 201);
    }

    public function createNote(Request $request, $id){
        $company = Company::find($id);
        $company->notes()->create($request->all());
        return response()->json(['msg' => 'Note Created Successfully'], 201);
    }

    public function deleteNote($id){
        $note = CompanyNote::findOrFail($id);
        $note->delete();
        return response()->json('Note Removed successfully.', 202);
    }

    public function createSite(Request $request, $id){
        $company = Company::find($id);
        $company->sites()->create($request->all());
        return response()->json(['msg' => 'Site Created Successfully'], 201);
    }

    public function fetchNotes ($id){
        $company = Company::find($id);
        $company_notes = $company->notes()->latest()->get();
        return response()->json($company_notes, 200);
    }

    public function show($id)
    {
        $company = Company::find($id);
        return response()->json($company, 200);
    }

    public function update(Request $request, $id)
    {
        $company = Company::find($id);
        $company->fill($request->all());
        $company->save();
        return response()->json($company, 200);
    }

    public function delete($id)
    {
        Company::find($id)->delete();
        return response()->json('Removed successfully.', 202);
    }

    public function checkEquipmentExist($equipmentId){
        $avail_company = DB::table('company_equipment')->where('equipment_id', $equipmentId)->count();
        if($avail_company > 0){
            return response()->json(['exist' => true]);
        }
        return response()->json(['exist' => false]);
    }

    public function assignEquipment($id, $equipmentId)
    {
        $equipment = DB::table('company_equipment')->where('equipment_id', $equipmentId)->exists();
//        TODO: put in a try catch statement
        if($equipment){
            $existing_company = DB::table('company_equipment')->where('equipment_id', $equipmentId)->first();
            $companyId = $existing_company->company_id;
            $old_company = Company::findOrFail($companyId);
            $old_company->equipments()->detach($equipmentId);
            $new_company = Company::findOrFail($id);
            $new_company->equipments()->attach($equipmentId);
            return response()->json(['msg'=>'Equipment Assign successfully'], 201);
        } else {
            $company = Company::findOrFail($id);
            $company->equipments()->attach($equipmentId);
            return response()->json(['msg'=>'Equipment Assign successfully'], 201);
        }
    }

    public function unassignEquipment($id, $equipmentId){
        $company = Company::findOrFail($id);
        $company->equipments()->detach($equipmentId);
        return response()->json(['msg'=>'Equipment removed from company successfully'], 201);
    }

    public function assignedEquipments($id)
    {
        $company_equipments = Company::find($id)->equipments()->get();

        $company_equipments = $company_equipments->map(function ($ce) {
            $ce->equipmen_model = $ce->type . $ce->code . $ce->series;
            return $ce;
        });
        return response()->json($company_equipments, 200);
    }

    public function assignedContacts($id)
    {
        $company_contacts = Company::find($id)->contactPeople()->get();
        return response()->json($company_contacts, 200);
    }

    public function checkContactExist($contactId){
        $avail_company = DB::table('company_contact')->get(['contactperson_id']);
        foreach ($avail_company as $ac) {
            if($ac->contactperson_id == $contactId) {
                return response()->json(['exist' => true]);
                break;
            }
        }
        return response()->json(['exist' => false]);
    }

    public function assignContact($id, $contactId){
        $contact = DB::table('company_contact')->where('contactperson_id', $contactId)->exists();
        if($contact){
            $existing_company = DB::table('company_contact')->where('contactperson_id', $contactId)->first();
            $companyId = $existing_company->company_id;
            $old_company = Company::findOrFail($companyId);
            $old_company->contactPeople()->detach($contactId);
            $new_company = Company::findOrFail($id);
            $new_company->contactPeople()->attach($contactId);
            return response()->json(['msg'=>'Contact Assign successfully'], 201);
        } else {
            $company = Company::findOrFail($id);
            $company->contactPeople()->attach($contactId);
            return response()->json(['msg'=>'Contact Assign successfully'], 201);
        }
    }

    public function unassignedContact($id, $contactId){
        $company = Company::find($id);
        $company->contactPeople()->detach($contactId);
        return response()->json(['msg'=>'contact removed from company successfully'], 201);
    }

    public function CompanySites($id)
    {
        $company_sites = Company::find($id)->sites()->latest()->get();
        return response()->json($company_sites, 200);
    }

    public function CompanyJobs($id){
//        Todo: Jonathan - fetch the job record from the request table that the where customer_name has the id passed in the args, you might need to create the relationship ursef
        $company = Company::find($id);
        $all_request = $company->request;
        $records = [];
        foreach($all_request as $request) {
            $records[] = [
                'id' => $request->id, 
                'reference' => $request->request_no, 
                'model' => $request->equipment_model, 
                'description' => $request->job_desc, 
                'serial_no' => $request->equipment_sn, 
                'job_start' => $request->plan_start, 
                'job_end' => $request->plan_end, 
                'status'=> $request->status
            ];
        }
        // $company_jobs = [
        //     ['id' => 1, 
        //     'reference' => 'JO-II08J', 
        //     'model' => 'adfcw', 
        //     'description' => 'fwefrwer', 
        //     'serial_no' => 'weewww', 
        //     'job_start' => '3232422', 
        //     'job_end' => '23223121', 
        //     'status'=> 'Done'],
        //     ['id' => 2, 'reference' => 'JO-II08J', 'model' => 'adfcw', 'description' => 'fwefrwer', 'serial_no' => 'weewww', 'job_start' => '3232422', 'job_end' => '23223121', 'status'=> 'Done'],
        // ];
        return response()->json($records, 200);
    }

    public function deleteSite($id, $siteId){
        $company = Company::find($id);
        $company->sites()->where('id', $siteId)->delete();
        return response()->json(['msg'=>'site removed from company successfully'], 201);
    }
}
