<?php

namespace App\Http\Controllers;

use App\ContactPeople;
use App\Company;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;

class ContactPeopleController extends Controller
{

    public function index()
    {
//        $contactpeople = Cache::remember('contactpeople', 23*60, function (){
//            return ContactPeople::with(['company' => function ($query) {
//                return $query->get();
//            }])->latest()->get()->toArray();
//        });

        $contactpeople = ContactPeople::with(['company' => function ($query) {
            return $query->get();
        }])->latest()->get()->toArray();

        $records = [];
        foreach($this->gen_func($contactpeople) as $people) {
            $people['company_name'] = ($people['company'])? $people['company'][0]['company_name'] : '';
            $people['company_id'] = ($people['company'])? $people['company'][0]['id'] : '';
            unset($people['company']);
            $records[] = $people;
        }

        return response()->json($records, 200);
    }

    public function create(Request $request)
    {
        DB::beginTransaction();
        try{
            //get company id from the request
            $data = $request->all();
            $company_id = '';

            if(array_key_exists('Company_id', $data)) {
                $company_id = $data['Company_id'];
                unset($data['Company_id']);
            }

            //create contact and get the insert id
            $contact_id = DB::table('contactperson')->insertGetId($data);
            // check if company already contains that id
            if(isset($company_id) && !empty($company_id)) {
                $company =  Company::findOrFail($company_id);
                $company->contactPeople()->attach($contact_id);
            }
            DB::commit();
            return response()->json($data, 201);
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json($e->getMessage(), 401);
        }
//        DB::transaction(function () use($data, $company_id) {
//            try{
//
//            } catch ()
//
//            if($company->contactPeople->contains($contact_id)){
//                dd('I already exist');
//            } else {
//                $company->contactPeople()->attach($contact_id);
//                return response()->json($data, 201);
//            }
//        });
    }

    public function show($id)
    {
        $contactpeople = ContactPeople::find($id);
        return response()->json($contactpeople);
    }
    
    public function update(Request $request, $id)
    {
        DB::beginTransaction();
        try{
            $data = $request->all();
            $company_id = $data['Company_id'];
            $contactpeople = ContactPeople::find($id);
            unset($data['Company_id']);
            $contactpeople->fill($data);
            $contactpeople->save();


            $company = Company::find($company_id);
            if(count($contactpeople->company) > 0) {
                $prev_company = $contactpeople->company[0];
            } else {
                $prev_company = 0;
            }

//        dd($prev_company);
            if(!$prev_company) {
                $company->contactPeople()->attach($contactpeople->id);
            } else if($company->id != $prev_company->id) {
                $p_company = Company::find($prev_company->id);

                //delete and resync
                $p_company->contactPeople()->detach($contactpeople->id);
                $company->contactPeople()->attach($contactpeople->id);
            }
            return response()->json($contactpeople);
        } catch (\Exception $e) {
            return response()->json($e->getMessage(), 401);
        }
//        $company->contactPeople()->sync($id);
    }

    public function delete($id)
    {
        $contactpeople = ContactPeople::find($id);
        $companys = $contactpeople->company;
        foreach ($companys as $company) {
            $company = Company::find($company->id);
            $company->contactPeople()->detach($contactpeople->id);
        }            
        ContactPeople::find($id)->delete();
        return response()->json('Removed successfully.', 202);
    }

    private function gen_func($items)
    {
        foreach($items as $item) {
            yield $item;
        }
    }
}
