<?php

namespace App\Http\Controllers;

use App\Equipment;
use App\EquipmentNote;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class EquipmentsController extends Controller
{

    public function index()
    {
        $equipments = Cache::remember('equipments', 23*60, function (){
            return Equipment::latest('id')->get();
        });
        $equipments = $equipments->map(function ($equiment) {
            $equiment->equipmen_model = $equiment->type . $equiment->code . $equiment->series;

            return $equiment;
        });
        unset($equipments['code']);
        unset($equipments['type']);
        unset($equipments['series']);
        unset($equipments['sub_division']);

        return response()->json($equipments, 200);
    }

    public function create(Request $request)
    {
        $input = $request->all();
        $model = explode('|', $input['equipmen_model']);
        $type = trim($model[0]);
        $code = trim($model[1]);
        $series = trim($model[2]);
        $sub_division = trim($model[3]);
        $input['type'] = $type;
        $input['code'] = $code;
        $input['series'] = $series;
        $input['sub_division'] = $sub_division;
        unset($input['equipmen_model']);

        $equipment = Equipment::create($input);
        return response()->json($equipment, 201);
    }

    public function show($id)
    {
        $equipment = Equipment::find($id);
        return response()->json($equipment);
    }
        
    public function update(Request $request, $id)
    {
        $equipment = Equipment::find($id);
        $input = $request->all();
        $model = explode('|', $input['equipmen_model']);
        $type = trim($model[0]);
        $code = trim($model[1]);
        $series = trim($model[2]);
        $sub_division = trim($model[3]);
        $input['type'] = $type;
        $input['code'] = $code;
        $input['series'] = $series;
        $input['sub_division'] = $sub_division;
        unset($input['equipmen_model']);
        $equipment->fill($input);
        $equipment->save();
        return response()->json($equipment);
    }

    public function delete($id)
    {
        Equipment::find($id)->delete();
        return response()->json('Removed successfully.', 202);
    }

    public function createNote(Request $request, $id){
        $equipment = Equipment::find($id);
        $equipment->notes()->create($request->all());
        return response()->json(['msg' => 'Note Created Successfully'], 201);
    }

    public function fetchNotes ($id){
        $equipment = Equipment::find($id);
        $equipment_notes = $equipment->notes()->latest()->get();
        return response()->json($equipment_notes, 200);
    }

    public function deleteNote($id){
        $note = EquipmentNote::findOrFail($id);
        $note->delete();
        return response()->json('Note Removed successfully.', 202);
    }

    public function equipmentJobs($id){
//        Todo: Jonathan - fetch the job record from the request table that the where equipment_sn has the id passed in the args, you might need to create the relationship ursef
        $company = Equipment::find($id);
        $all_request = $company->request;
        $records = [];
        foreach($all_request as $request) {
            $records[] = [
                'id' => $request->id, 
                'reference' => $request->request_no, 
                'model' => $request->equipment_model, 
                'description' => $request->job_desc, 
                'serial_no' => $request->equipment_sn, 
                'job_start' => $request->plan_start, 
                'job_end' => $request->plan_end, 
                'status'=> $request->status
            ];
        }
        // $equipment_jobs = [
        //     ['id' => 1, 
        //     'reference' => 'JO-II08J', 
        //     'model' => 'adfcw', 
        //     'description' => 'fwefrwer', 
        //     'serial_no' => 'weewww', 
        //     'job_start' => '3232422', 
        //     'job_end' => '23223121', 
        //     'status'=> 'Done'],
        //     ['id' => 2, 'reference' => 'JO-II08J', 'model' => 'adfcw', 'description' => 'fwefrwer', 'serial_no' => 'weewww', 'job_start' => '3232422', 'job_end' => '23223121', 'status'=> 'Done'],
        // ];
        return response()->json($records, 200);
    }
}
