<?php
/**
 * Created by PhpStorm.
 * User: Verem
 * Date: 24/02/2018
 * Time: 10:26 AM
 */

namespace App\Http\Controllers;


use App\Profile;

class ProfilesController extends Controller
{
    public function index()
    {
        $profiles = Profile::all();

        return response()->json($profiles);
    }


    public function getEngineers()
    {
        $engineerProfiles = Profile::where('position', 'like', '%engineer%')->get();

        if ($engineerProfiles->count() > 0) {
            $engineers = $engineerProfiles->map(function ($profile) {
                return $profile->user;
            });

            return response()->json($engineers);
        }

        return response()->json([]);
    }
}