<?php

namespace App\Observers;

use App\Company;
use Illuminate\Support\Facades\Cache;

/**
 * Class CampanyObserver
 * @package App\Observers
 */
class CompanyObserver
{
    /**
     * Listen to the Company created event.
     *
     * @param  \App\Company  $company
     * @return void
     */
    public function created(Company $company)
    {
        Cache::forget('companies');
    }

    /**
     * Listen to the Company deleting event.
     *
     * @param  \App\Company  $company
     * @return void
     */
    public function deleted(Company $company)
    {
        Cache::forget('companies');
    }

    /**
     * Listen to the Company updating event.
     *
     * @param  \App\Company  $company
     * @return void
     */
    public function updated(Company $company)
    {
        Cache::forget('companies');
    }

}
