<?php

namespace App\Observers;

use App\Equipment;
use Illuminate\Support\Facades\Cache;

/**
 * Class EquipmentObserver
 * @package App\Observers
 */
class EquipmentObserver
{
    /**
     * Listen to the Equipment created event.
     *
     * @param  \App\Equipment  $equipment
     * @return void
     */
    public function created(Equipment $equipment)
    {
        Cache::forget('equipments');
    }

    /**
     * Listen to the Equipment deleting event.
     *
     * @param  \App\Equipment  $equipment
     * @return void
     */
    public function deleted(Equipment $equipment)
    {
        Cache::forget('equipments');
    }

    /**
     * Listen to the Equipment updating event.
     *
     * @param  \App\Equipment  $equipment
     * @return void
     */
    public function updated(Equipment $equipment)
    {
        Cache::forget('equipments');
    }

}
