<?php

namespace App\Observers;

use App\JobExpenses;
use Illuminate\Support\Facades\Cache;

/**
 * Class JobExpensesObserver
 * @package App\Observers
 */
class JobExpensesObserver
{
    /**
     * Listen to the JobExpenses created event.
     *
     * @param  \App\JobExpenses  $job_expenses
     * @return void
     */
    public function created(JobExpenses $job_expenses)
    {
        Cache::forget('job_expenses');
    }

    /**
     * Listen to the JobExpenses deleting event.
     *
     * @param  \App\JobExpenses  $job_expenses
     * @return void
     */
    public function deleted(JobExpenses $job_expenses)
    {
        Cache::forget('job_expenses');
    }

    /**
     * Listen to the JobExpenses updating event.
     *
     * @param  \App\JobExpenses  $job_expenses
     * @return void
     */
    public function updated(JobExpenses $job_expenses)
    {
        Cache::forget('job_expenses');
    }

}
