<?php

namespace App\Observers;

use App\JobRequest;
use Illuminate\Support\Facades\Cache;

/**
 * Class JobRequestObserver
 * @package App\Observers
 */
class JobRequestObserver
{
    /**
     * Listen to the JobRequest created event.
     *
     * @param  \App\JobRequest  $job_requests
     * @return void
     */
    public function created(JobRequest $job_requests)
    {
        Cache::forget('job_requests');
    }

    /**
     * Listen to the JobRequest deleting event.
     *
     * @param  \App\JobRequest  $job_requests
     * @return void
     */
    public function deleted(JobRequest $job_requests)
    {
        Cache::forget('job_requests');
    }

    /**
     * Listen to the JobRequest updating event.
     *
     * @param  \App\JobRequest  $job_requests
     * @return void
     */
    public function updated(JobRequest $job_requests)
    {
        Cache::forget('job_requests');
    }

}
