<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTableRequests extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('requests', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('company_id');
            $table->unsignedInteger('equipment_id');
            $table->string('job_type')->nullable();
            $table->string('equipment_sn')->nullable();
            $table->string('equipment_model')->nullable();
            $table->string('fleet_number')->nullable();
            $table->string('customer_name')->nullable();
            $table->string('site')->nullable();
            $table->json('engineers')->nullable();
            $table->string('status')->nullable();
            $table->text('job_desc')->nullable();
            $table->string('sms_no')->nullable();
            $table->string('planing_needed')->nullable();
            $table->date('plan_start')->nullable();
            $table->date('plan_end')->nullable();
            $table->string('urgency')->nullable();
            $table->text('comments')->nullable();
            $table->string('request_no')->nullable()->unique();
            $table->string('related_quotation')->nullable();
            $table->string('project_no')->nullable();
            $table->string('customer_order_no')->nullable();
            $table->string('operation_hours')->nullable();
            $table->string('plate_no')->nullable();
            $table->string('order_completed')->nullable();
            $table->boolean('issued')->nullable()->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('requests');
    }
}
