<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProfilesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('profiles', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('user_id')->foreign()
                ->references('id')->on('users')->onDelete('cascade');
            $table->string('mobile_2')->nullable();
            $table->string('landline')->nullable();
            $table->string('personal_email')->nullable();
            $table->string('marital_status')->nullable();
            $table->string('dob')->nullable();
            $table->string('country')->nullable();
            $table->string('state_province')->nullable();
            $table->string('city')->nullable();
            $table->string('area')->nullable();
            $table->string('road')->nullable();
            $table->string('house_no')->nullable();
            $table->string('nationality')->nullable();
            $table->string('staff_id_lnl')->nullable();
            $table->string('staff_id_sog')->nullable();
            $table->string('department')->nullable();
            $table->string('division')->nullable();
            $table->string('position')->nullable();
            $table->string('work_permit_require')->nullable();
            $table->string('work_permit_expiry_date')->nullable();
            $table->string('work_permit')->nullable();
            $table->string('passport_expiry_date')->nullable();
            $table->string('passport')->nullable();
            $table->string('visa_available')->nullable();
            $table->string('visa_country')->nullable();
            $table->string('duration')->nullable();
            $table->string('visa_type')->nullable();
            $table->integer('number_of_entries')->nullable();
            $table->string('electronic_signature')->nullable();
            $table->integer('pant_size')->nullable();
            $table->integer('shirt_size')->nullable();
            $table->integer('boot_size')->nullable();
            $table->string('parka')->nullable();
            $table->integer('parka_size')->nullable();
            $table->integer('parka_qty')->nullable();
            $table->integer('gloves_size')->nullable();
            $table->string('gloves')->nullable();
            $table->string('glove_type')->nullable();
            $table->integer('glove_qty')->nullable();
            $table->string('helmet')->nullable();
            $table->integer('helmet_qty')->nullable();
            $table->string('safety_harness')->nullable();
            $table->integer('safety_harness_qty')->nullable();
            $table->string('safety_goggles')->nullable();
            $table->integer('safety_goggles_qty')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('profiles');
    }
}
