<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateHoursReportsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hours_reports', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('user_id')->unsigned()->foreign()
                ->references('id')->on('users')->onDelete('cascade');
            $table->integer('request_id')->unsigned()->foreign()
                ->references('id')->on('requests')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('hours_reports');
    }
}
