<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateJobExpensesItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('job_expenses_items', function (Blueprint $table) {
            $table->increments('id');
            $table->string('currency')->nullable();
            $table->integer('qty')->nullable();
            $table->string('voucher')->nullable();
            $table->decimal('amount', 12, 2)->nullable();
            $table->integer('request_id')->unsigned()->foreign()
                ->references('id')->on('requests')->onDelete('cascade');
            $table->integer('user_id')->unsigned()->foreign()
                ->references('id')->on('users')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('job_expenses_items');
    }
}
