<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateJobDescTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('jobs_desc', function (Blueprint $table) {
            $table->increments('id');
            $table->string('personal_no')->nullable();
            $table->string('service_act_no')->nullable();
            $table->string('project_no')->nullable();
            $table->string('customer_order_no')->nullable();
            $table->string('customer_no')->nullable();
            $table->string('land')->nullable();
            $table->string('new')->nullable();
            $table->string('company_order_form')->nullable();
            $table->string('machine_type')->nullable();
            $table->string('code')->nullable();
            $table->string('operation_hour')->nullable();
            $table->string('company')->nullable();
            $table->string('serial_no')->nullable();
            $table->string('no_plate')->nullable();
            $table->string('order_completed')->nullable();
            $table->string('gbv')->nullable();
            $table->string('cost_centre')->nullable();
            $table->string('h_t_o')->nullable();
            $table->string('mseg')->nullable();
            $table->string('destination')->nullable();
            $table->string('work_purpose')->nullable();
            $table->integer('request_id')->unsigned()->foreign()
                ->references('id')->on('requests')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('jobs_desc');
    }
}
