<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Issue Report</title>
    <style>
        @page {
            margin-top: 3em;
            margin-bottom: 3em;
            margin-left: 1em;
            margin-right: 1em;
        }

        body {
            margin: 0;
            padding: 0;
            font-family: Arial, sans-serif;
            font-size: 9px;
        }

        table {
            width: 100%;
        }

        table, tr, td, th, thead, tbody, p {
            padding: 0;
            margin: 0;
        }

        p {
            text-align: center !important;
            font-weight: bold;
            margin-top: 3px;
        }

        h1 {
            font-size: 3em;
            padding: 0;
            margin: 0;
        }

        .hr-body {
            border-bottom: 6px solid #ffc101;
            border-top: 6px solid #ffc101;
            margin-top: 3px;
            padding-top: 5px;
            padding-bottom: 5px;
        }

        .center {
            text-align: center;
        }

        .page-no {
            font-size: 1.5em;
            vertical-align: top;
        }

        .table-border {
            border-collapse: collapse;
        }

        .table-border, .table-border td, .table-border th {
            border: 1px solid #333;
            padding: 3px;
            text-align: center;
        }

        .row-bg {
            background-color: lightgray;
            text-align: center;
            font-size: 10px;
        }

        .dark-bg {
            background-color: darkgray !important;
        }

        .total-border {
            border-top: 2px solid #333333 !important;
        }

        .left {
            text-align: left !important;
            vertical-align: top;
        }

        .logo {
            font-family: Liebherr, sans-serif !important;
            font-size: 54px;
        }
    </style>
</head>
<body>
<table>
    <tbody>
    <tr>
        <td width="33.3333%" class="logo"><img
                    src="data:image/gif;base64,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"
                    width="250" height="35"></td>
        <td width="33.3333%" class="center"><h1>Hours-Report</h1></td>
        <td width="33.3333%" class="center page-no"></td>
    </tr>
    </tbody>
</table>
<table class="hr-body">
    <tr>
        <td style="padding: 0">
            <table class="table-border">
                <tbody>
                <tr>
                    <td colspan="3" class="left">Personal no. <p> <?= $report->personal_no ?></p></td>
                    <td colspan="3" class="left">Service action no.</td>
                    <td colspan="3" class="left">Project no. <p> <?= $report->request_no ?> </p></td>
                    <td colspan="3" class="left">Customer order no. <p> <?= $report->customer_order_no ?>  </p></td>
                    <td colspan="2" class="left">Customer no. <p> <?= $report->reference ?> </p></td>
                    <td colspan="3" class="left">Land <p> Nigeria </p></td>
                    <td class="left">New <p> NG </p></td>
                    <td colspan="12" class="left">Company / Order form <p> <?= $report->customer_name ?> </p></td>
                </tr>
                <tr>
                    <td colspan="3" class="left">Machine type <p> <?= $report->type ?> </p></td>
                    <td colspan="2" class="left">Code <p> <?= $report->code . $report->series ?></p></td>
                    <td colspan="2" class="left">Operation Hours <p> <?= $report->operation_hours ?></p></td>
                    <td colspan="2" class="left">Company <p> <?= $report->division ?></p></td>
                    <td colspan="3" class="left">Serial number</td>
                    <td colspan="3" class="left">Number plate <p> <?= $report->plate_no ?></p></td>
                    <td colspan="3" class="left">Order completed <p> <?= $report->order_completed ?></p></td>
                    <td colspan="2" class="left">GBV</td>
                    <td colspan="4" class="left">Cost centre</td>
                    <td colspan="3" class="left">H/T/O</td>
                    <td colspan="3" class="left">MSEG</td>
                </tr>
                <tr>
                    <td colspan="4" class="left">Destination / place / site</td>
                    <td colspan="26" class="left"><p style="text-align: left !important;"><?= $report->site ?></p></td>
                </tr>
                <tr>
                    <td colspan="4" class="left">Work / purpose</td>
                    <td colspan="26" class="left"><p style="text-align: left !important;"><?= $report->job_desc ?></p>
                    </td>
                </tr>
                <tr class="row-bg">
                    <td rowspan="2">Item</td>
                    <td rowspan="2">Day</td>
                    <td colspan="3">Date</td>
                    <td colspan="2">Total Time</td>
                    <td colspan="2">Break</td>
                    <td rowspan="2">Norm Hours</td>
                    <td rowspan="2">25% Hours</td>
                    <td rowspan="2">50% Hours</td>
                    <td rowspan="2">100% Hours</td>
                    <td rowspan="2">Travelling From</td>
                    <td rowspan="2">Arrival In</td>
                    <td colspan="2">Travelling Time</td>
                    <td rowspan="2">Normal</td>
                    <td rowspan="2">20%</td>
                    <td rowspan="2">50%</td>
                    <td rowspan="2">100%</td>
                    <td rowspan="2">Land</td>
                    <td colspan="3">Free</td>
                    <td rowspan="2" colspan="2">K</td>
                    <td rowspan="2" colspan="3">Km</td>
                </tr>
                <tr class="row-bg">
                    <td>Day</td>
                    <td>Month</td>
                    <td>Year</td>
                    <td>From</td>
                    <td>To</td>
                    <td>From</td>
                    <td>To</td>
                    <td>From</td>
                    <td>To</td>
                    <td>B</td>
                    <td>L</td>
                    <td>D</td>
                </tr>
                <?php
                function convertTimestampToHours($timestamp){
                    if($timestamp < 1) {
                        return "";
                    } else {
                        $hours = round($timestamp / SECONDS_PER_HOUR, 0, PHP_ROUND_HALF_DOWN);
                        $minutes = ($timestamp % SECONDS_PER_HOUR) / 60;

                        $time_diff = $hours.".".$minutes;
                        return $time_diff;
                    }
                }
                function differenceInHours($startdate,$enddate){
                    $difference = abs($enddate - $startdate)/3600;
                    return $difference;
                }
                $totalWorkNorm = [];
                $totalWork25 = [];
                $totalWork50 = [];
                $totalWork100 = [];
                $totalTravelNorm = [];
                $totalTravel25 = [];
                $totalTravel50 = [];
                $totalTravel100 = [];
                if (!$report->timesheet_items->isEmpty()) {
                    $i = 1;
                    define("SECONDS_PER_HOUR", 60*60);
                    foreach ($report->timesheet_items as $timesheet_item) {
                        $type = $timesheet_item->type;
                        $holiday = $timesheet_item->public_holiday;
                        $day_name = $timesheet_item->day_name;
                        $day = $timesheet_item->day;
                        $month = $timesheet_item->month;
                        $year = $timesheet_item->year;
                        $date = $day."-".$month."-".$year;
                        $start_work = strtotime($date ." ". $timesheet_item->work_from);
                        $end_work = strtotime($date ." ". $timesheet_item->work_to);
                        $break_from = strtotime($date." ".$timesheet_item->break_from);
                        $break_to = strtotime($date." ".$timesheet_item->break_to);
                        $opening_time = strtotime($date." 8:00");
                        $closing_time = strtotime($date." 5:00");
                        $workNorm = '';
                        $work25 = '';
                        $work50 = '';
                        $work100 = '';
                        $travelNorm = '';
                        $travel25 = '';
                        $travel50 = '';
                        $travel100 = '';
                        $break = $break_to - $break_from;

                        if($day_name == 'Sun' && $holiday == 'No'){
                            $difference = ($end_work - $start_work) - $break;
                            $totalWork50[] = $difference;
                            $work50 = convertTimestampToHours($difference);
                        } elseif ($holiday == 'Yes'){
                            $difference = ($end_work - $start_work) - $break;
                            $totalWork100[] = $difference;
                            $work100 = convertTimestampToHours($difference);
                        } else {
                            $overtime = 0;
                            if($start_work < $opening_time && $end_work <= $opening_time){
                                $difference = ($end_work - $start_work) - $break;
                                $workNorm = convertTimestampToHours($difference);
                                $totalWorkNorm[] = $difference;
                                $overtime = $overtime + $difference;
                                $totalWork25[] = $overtime;
                                $work25 = convertTimestampToHours($overtime);
                            }
//                            if(($start_work <= $opening_time) && ($end_work > $opening_time && $end_work <= $closing_time)) {
//                                $difference = ($end_work - $opening_time) - $break;
//                                $totalWorkNorm[] = $difference;
//                                $overtime = $opening_time - $start_work;
//                                $totalWork25[] = $overtime;
//                                $workNorm = convertTimestampToHours($difference);
//                                $work25 = convertTimestampToHours($overtime);
//                            }
//                            if($start_work <= $opening_time && $end_work > $closing_time) {
//                                $difference = ($closing_time - $opening_time) - $break;
//                                $totalWorkNorm[] = $difference;
//                                $overtime = $opening_time - $start_work;
//                                $overtime = $overtime + $end_work - $closing_time;
//                                $totalWork25[] = $overtime;
//                                $workNorm = convertTimestampToHours($difference);
//                                $work25 = convertTimestampToHours($overtime);
//                            }
//                            if ($start_work >= $opening_time && $end_work <= $closing_time) {
//                                $difference = ($end_work - $start_work) - $break;
//                                $totalWorkNorm[] = $difference;
//                                $workNorm = convertTimestampToHours($difference);
//                            }
                        }

//                        $totalWorkNorm[] = $difference;
//                        $hours = round($difference / SECONDS_PER_HOUR, 0, PHP_ROUND_HALF_DOWN);
//                        $minutes = ($difference % SECONDS_PER_HOUR) / 60;
//                        $time_diff = $hours.":".$minutes;
                        ?>
                        <tr>
                            <td><?= $i++ ?></td>
                            <td><?= $timesheet_item->day_name ?></td>
                            <td><?= $timesheet_item->day ?></td>
                            <td><?= $timesheet_item->month ?></td>
                            <td><?= $timesheet_item->year ?></td>
                            <td><?= $timesheet_item->work_from ?></td>
                            <td><?= $timesheet_item->work_to ?></td>
                            <td><?= $timesheet_item->break_from ?></td>
                            <td><?= $timesheet_item->break_to ?></td>
                            <td><?= $workNorm ?></td>
                            <td><?= $work25 ?></td>
                            <td><?= $work50 ?></td>
                            <td><?= $work100 ?></td>
                            <td></td>
                            <td></td>
                            <td><?= $timesheet_item->travelling_from ?></td>
                            <td><?= $timesheet_item->travelling_to ?></td>
                            <td><?= $travelNorm; ?></td>
                            <td><?= $travel25; ?></td>
                            <td><?= $travel50; ?></td>
                            <td><?= $travel100; ?></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td colspan="2"></td>
                            <td colspan="3"></td>
                        </tr>
                        <?php
                    }
                    $totalItems = count($report->timesheet_items);
                    $number = $totalItems + 1;
                    if ($totalItems < 12) {
                        for ($i = 1; $i <= (12 - $totalItems); $i++) { ?>
                            <tr>
                                <td><?= $number++ ?></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td colspan="2"></td>
                                <td colspan="3"></td>
                            </tr>
                        <?php }
                    }
                } ?>
                <tr>
                    <td colspan="8"></td>
                    <td class="total-border" style="font-weight: bold">Total</td>
                    <td class="total-border"><?= convertTimestampToHours(array_sum($totalWorkNorm)); ?></td>
                    <td class="total-border"><?= convertTimestampToHours(array_sum($totalWork25)); ?></td>
                    <td class="total-border"><?= convertTimestampToHours(array_sum($totalWork50)); ?></td>
                    <td class="total-border"><?= convertTimestampToHours(array_sum($totalWork100)); ?></td>
                    <td colspan="3"></td>
                    <td class="total-border" style="font-weight: bold">Total</td>
                    <td class="total-border"><?= convertTimestampToHours(array_sum($totalTravelNorm)); ?></td>
                    <td class="total-border"><?= convertTimestampToHours(array_sum($totalTravel25)); ?></td>
                    <td class="total-border"><?= convertTimestampToHours(array_sum($totalTravel50)); ?></td>
                    <td class="total-border"><?= convertTimestampToHours(array_sum($totalTravel100)); ?></td>
                    <td colspan="9"></td>
                </tr>
                <tr class="row-bg">
                    <td>Item</td>
                    <td class="dark-bg">K</td>
                    <td colspan="2">Currency</td>
                    <td>Qty</td>
                    <td colspan="3">Voucher</td>
                    <td colspan="3">Amount</td>
                    <td colspan="2" class="dark-bg">Debit</td>
                    <td colspan="1" class="dark-bg">A</td>
                    <td>Item</td>
                    <td class="dark-bg">K</td>
                    <td colspan="2">Currency</td>
                    <td>Qty</td>
                    <td colspan="3">Voucher</td>
                    <td colspan="4">Amount</td>
                    <td colspan="2" class="dark-bg">Debit</td>
                    <td colspan="2" class="dark-bg">A</td>
                </tr>
                <?php
                $totalExpenses = count($report->job_expenses);
                for ($init = 0; $init < $totalExpenses; $init += 2) {
                    ?>
                    <tr>
                        <?php
                        $splitCount = ($totalExpenses % 2) == 0 ? ($init + 2) : ($init + ($init == 0 ? ($totalExpenses == 1) ? 1 : 2 : 1));
                        for ($j = $init; $j < $splitCount; $j++) { ?>
                            <td><?= $j + 1 ?></td>
                            <td></td>
                            <td colspan="2"><?= $report->job_expenses[$j]->currency ?></td>
                            <td><?= $report->job_expenses[$j]->qty ?></td>
                            <td colspan="3"><?= $report->job_expenses[$j]->voucher ?></td>
                            <td colspan="3"><?= $report->job_expenses[$j]->amount ?></td>
                            <td colspan="2"></td>
                            <td colspan="2"></td>
                            <?php
                        }
                        if ($init == ($splitCount - 1) && ($totalExpenses % 2) == 1) {
                            ?>
                            <td></td>
                            <td></td>
                            <td colspan="2"></td>
                            <td></td>
                            <td colspan="3"></td>
                            <td colspan="3"></td>
                            <td colspan="2"></td>
                            <td colspan="2"></td>
                        <?php } ?>
                    </tr>
                    <?php
                }
                if ($totalExpenses < 10) {
                    $rows = (10 - $totalExpenses);
                    for ($i = 1; $i <= (((($rows % 2) == 0) ? $rows : $rows - 1) / 2); $i++) { ?>
                        ?>
                        <tr>
                            <td>&nbsp;</td>
                            <td></td>
                            <td colspan="2"></td>
                            <td></td>
                            <td colspan="3"></td>
                            <td colspan="3"></td>
                            <td colspan="2"></td>
                            <td colspan="2"></td>
                            <td></td>
                            <td></td>
                            <td colspan="2"></td>
                            <td></td>
                            <td colspan="3"></td>
                            <td colspan="3"></td>
                            <td colspan="2"></td>
                            <td colspan="2"></td>
                        </tr>
                    <?php }
                } ?>
                <tr class="row-bg" style="text-align: left">
                    <td colspan="5">Remark</td>
                    <td colspan="25"></td>
                </tr>
                <tr>
                    <td colspan="5" rowspan="3"></td>
                    <td colspan="5">Name in block letters / date</td>
                    <td colspan="6"></td>
                    <td colspan="5"></td>
                    <td colspan="9"></td>
                </tr>
                <tr>
                    <td colspan="5" rowspan="2"></td>
                    <td colspan="6">&nbsp;</td>
                    <td colspan="5"></td>
                    <td colspan="9"></td>
                </tr>
                <tr>
                    <td colspan="6">Stamp and signature of customer <br> &nbsp;</td>
                    <td colspan="5">Signature service engineer <br> &nbsp;</td>
                    <td colspan="9">Signature service manager <br> &nbsp;</td>
                </tr>
                </tbody>
            </table>
        </td>
    </tr>
</table>
</body>
</html>