<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Equipment extends Model
{
    protected $table = 'equipment';
    protected $guarded = ['id'];

    public $timestamps = false;

    public function companies(){
        return $this->belongsToMany('App\Company');
    }

    public function notes(){
        return $this->hasMany('App\EquipmentNote');
    }

    public function request() {
    	return $this->hasMany('App\JobRequest', 'equipment_id');
    }

    public function setEquipmodelAttribute($value)
    {
        $this->attributes['equipmodel'] = $value;
    }
}
