<?php

namespace App\Http\Controllers;

use App\HoursReport;
use App\JobRequest;
use Illuminate\Http\Request;

class HoursReportController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    public function store(Request $request, $reqId)
    {
        $report = JobRequest::findOrFail($reqId);
        $report->hours_report()->create($request->all());

        return response()->json(['msg' => 'Created successfully'], 201);
    }

    public function get_hours_report($id)
    {
        $report = HoursReport::with('hours_report_desc', 'timesheet',
            'timesheet.timesheet_items', 'job_expenses', 'job_expenses.job_expenses_items')
            ->whereUserId($id)->get();

        return response()->json($report, 200);
    }

    public function hours_report_desc()
    {
        //
    }

}
