<?php

namespace App\Http\Controllers;

use App\Mail\Welcome;
use App\User;
use App\Company;
use App\ContactPeople;
use App\TrainingCertificate;
use App\Notifications\UserRegistration;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;

//use Illuminate\Hashing\BcryptHasher;

class UsersController extends Controller
{
    public function setup(){
        $companies = Company::all(['id', 'company_name']);
        $contactpeople = ContactPeople::all(['id', 'FirstName', 'LastName']);
        return response()->json(compact('companies', 'contactpeople'), 200);
    }

    public function index()
    {
         $users = Cache::remember('users', 23*60, function (){
             return User::latest()->get();
         });
        return response()->json($users, 200);
    }

    public function login(Request $request){
//        $this->validate($request, [
//            'username' => 'required|email',
//            'password' => 'required'
//        ]);

        $user = User::where('email', $request->input('username'))->where('active', true)->first();

        if ($user === null) {
            return response()->json(['error' => 'Invalid username or password'], 401);
        }
        $permissions = $user->permissions;

        if(Hash::check($request->input('password'), $user->password)){
            $apikey = base64_encode(str_random(40));
            User::where('email', $request->input('username'))->update(['api_token' => "$apikey"]);
            return response()->json(['status' => 'success','token' => $apikey, 'user' => $user, 'permissions' => $permissions]);
        }
        else{
            return response()->json(['status' => 'fail'], 401);
        }
    }

//    public function profile($id){
//        $user = User::find($id);
//        $profile = $user->profile()->get();
//        $certificates = $user->training_certificates()->get();
//        return response()->json(compact('user', 'profile', 'certificates'), 200);
//    }
    public function profile($id){
        $user = User::with('profile', 'training_certificates')->where('id', $id)->first();
        return response()->json($user, 200);
    }

    public function updateProfile(Request $request, $id){
        $user = User::findOrFail($id);
        $user->first_name = $request->input('first_name');
        $user->last_name = $request->input('last_name');
        $user->gender = $request->input('gender');
        $user->email = $request->input('email');
        $user->phone_number = $request->input('phone_number');

        if ($user->save()){
            $user->profile()->update([
                'mobile_2' => $request->input('mobile_2'),
                'landline' => $request->input('landline'),
                'personal_email' => $request->input('personal_email'),
                'marital_status' => $request->input('marital_status'),
                'dob' => $request->input('dob'),
                'country' => $request->input('country'),
                'state_province' => $request->input('state_province'),
                'city' => $request->input('city'),
                'area' => $request->input('area'),
                'road' => $request->input('road'),
                'house_no' => $request->input('house_no'),
                'nationality' => $request->input('nationality'),
                'staff_id_lnl' => $request->input('staff_id_lnl'),
                'staff_id_sog' => $request->input('staff_id_sog'),
                'department' => $request->input('department'),
                'division' => $request->input('division'),
                'position' => $request->input('position'),
                'work_permit_require' => $request->input('work_permit_require'),
                'work_permit_expiry_date' => $request->input('work_permit_expiry_date'),
                'work_permit' => $request->input('work_permit'),
                'passport_expiry_date' => $request->input('passport_expiry_date'),
                'passport' => $request->input('passport'),
                'visa_available' => $request->input('visa_available'),
                'visa_country' => $request->input('visa_country'),
                'duration' => $request->input('duration'),
                'visa_type' => $request->input('visa_type'),
                'number_of_entries' => $request->input('number_of_entries'),
                'electronic_signature' => $request->input('electronic_signature'),
                'pant_size' => $request->input('pant_size'),
                'shirt_size' => $request->input('shirt_size'),
                'boot_size' => $request->input('boot_size'),
                'parka' => $request->input('parka'),
                'parka_size' => $request->input('parka_size'),
                'parka_qty' => $request->input('parka_qty'),
                'gloves_size' => $request->input('gloves_size'),
                'gloves' => $request->input('gloves'),
                'glove_type' => $request->input('glove_type'),
                'glove_qty' => $request->input('glove_qty'),
                'helmet' => $request->input('helmet'),
                'helmet_qty' => $request->input('helmet_qty'),
                'safety_harness' => $request->input('safety_harness'),
                'safety_harness_qty' => $request->input('safety_harness_qty'),
                'safety_goggles' => $request->input('safety_goggles'),
                'safety_goggles_qty' => $request->input('safety_goggles_qty'),
            ]);

            return response()->json($request, 201);
        }
        return response()->json(['msg' => 'Fail to update user profile'], 401);
    }

    public function addCertificate(Request $request, $id){

        $certificate = TrainingCertificate::create([
            'user_id' => $id,
            'description' => $request->input('description'),
            'date' => $request->input('date'),
            'expiry_date' => $request->input('expiry_date'),
            'authority' => $request->input('authority'),
            'notes' => $request->input('notes'),
            'certificate' => $request->input('certificate')
        ]);
        if($certificate){
            return response()->json($certificate, 201);
        }
        else{
            return response()->json(['msg' => 'Could not add Training Certificate'], 401);
        }
    }

    public function deleteCertificate($id){
        $certificate = TrainingCertificate::find($id);
        $certificate->delete();
        return response()->json(['msg' => 'Certificate deleted successfully'], 201);
    }

    public function register(Request $request)
    {
        // $this->validate($request, [
        //     'first_name' => 'required|string',
        //     'last_name' => 'required|string',
        //     'email' => 'required|email|unique:users',
        //     'password' => 'required',
        //     'gender' => 'required',
        //     'phone_number' => 'required',
        // ]);

        $request['password'] = app('hash')->make($request['password']);
        $user = User::create($request->all());
        $user->profile()->create();

        try {
            // Send a welcome mail to the newly registered user
            Mail::to($user)->send(new Welcome($user));
        }
        catch (\Exception $e) {
            Log::error($e->getMessage());
        }

        return response()->json($user, 201);
    }

    public function changePassword(Request $request){
//        $this->validate($request, [
//            'username' => 'required|email',
//            'old_password' => 'required',
//            'new_password' => 'required'
//        ]);

        $user = User::where('email', $request->input('username'))->first();
        $permissions = $user->permissions;
        if(Hash::check($request->input('old_password'), $user->password)){
            $new_password = app('hash')->make($request['new_password']);
            $apikey = base64_encode(str_random(40));
            User::where('email', $request->input('username'))->update(['password' => $new_password, 'api_token' => "$apikey"]);
            return response()->json(['status' => 'success','token' => $apikey, 'user' => $user, 'permissions' => $permissions]);
        }
        else{
            return response()->json(['status' => 'fail'], 401);
        }
    }

   public function delete($id)
   {
       $user = User::find($id);
       if($user){
           $user->delete();
       }
       return response()->json('Removed successfully.', 202);
   }

   public function activate(Request $request, $id)
   {
       $user = User::findOrFail($id);
       $user->assignRole($request->input('user_role'));
       $user->active = "true";
       $user->save();

       return response()->json('User now active.', 202);
   }

   public function deactivate($id)
   {
       $user = User::findOrFail($id);
       $user->removeRole($user->getRoleNames()[0]);
       $user->active = "false";
       $user->save();

       return response()->json('User deactived.', 202);
   }

   public function getRoles(){
       $roles = Cache::remember('roles', 23*60, function (){
            return DB::select('select name from roles');
        });
        return response()->json($roles, 200);
   }
}
