<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class JobRequest extends Model
{
    protected $table = 'requests';
    protected $guarded = ['id'];

    public function hours_report(){
        return $this->hasOne(HoursReport::class, 'request_id');
    }

    public function timesheet_items(){
        return $this->hasMany(TimeSheetItems::class, 'request_id');
    }

    public function job_expenses(){
        return $this->hasMany(JobExpensesItems::class, 'request_id');
    }

    public function request_desc(){
        return $this->hasOne(JobDesc::class, 'request_id');
    }

}
