<?php

namespace App\Observers;

use App\ContactPeople;
use Illuminate\Support\Facades\Cache;

/**
 * Class ContactPeopleObserver
 * @package App\Observers
 */
class ContactPeopleObserver
{
    /**
     * Listen to the ContactPeople created event.
     *
     * @param  \App\ContactPeople  $contactPeople
     * @return void
     */
    public function created(ContactPeople $contactPeople)
    {
        Cache::forget('contactpeople');
    }

    /**
     * Listen to the ContactPeople deleting event.
     *
     * @param  \App\ContactPeople  $contactPeople
     * @return void
     */
    public function deleted(ContactPeople $contactPeople)
    {
        Cache::forget('contactpeople');
    }

    /**
     * Listen to the ContactPeople updating event.
     *
     * @param  \App\ContactPeople  $contactPeople
     * @return void
     */
    public function updated(ContactPeople $contactPeople)
    {
        Cache::forget('contactpeople');
    }

}
