<?php

namespace App\Observers;

use App\User;
use Illuminate\Support\Facades\Cache;

/**
 * Class UserObserver
 * @package App\Observers
 */
class UserObserver
{
    /**
     * Listen to the User created event.
     *
     * @param  \App\User  $user
     * @return void
     */
    public function created(User $user)
    {
         Cache::forget('users');
    }

    /**
     * Listen to the User deleting event.
     *
     * @param  \App\User  $user
     * @return void
     */
    public function deleted(User $user)
    {
        Cache::forget('users');
    }

    /**
     * Listen to the User updating event.
     *
     * @param  \App\User  $user
     * @return void
     */
    public function updated(User $user)
    {
        Cache::forget('users');
    }

}
