<?php

namespace App\Providers;

use App\Company;
use App\ContactPeople;
use App\Equipment;
use App\JobExpenses;
use App\JobRequest;
use App\Observers\CompanyObserver;
use App\Observers\ContactPeopleObserver;
use App\Observers\EquipmentObserver;
use App\Observers\JobExpensesObserver;
use App\Observers\JobRequestObserver;
use App\Observers\UserObserver;
use App\User;
use Illuminate\Support\ServiceProvider;
use Illuminate\Http\Response;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        User::observe(UserObserver::class);
        Company::observe(CompanyObserver::class);
        ContactPeople::observe(ContactPeopleObserver::class);
        Equipment::observe(EquipmentObserver::class);
        JobExpenses::observe(JobExpensesObserver::class);
        JobRequest::observe(JobRequestObserver::class);
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->configure('services');

        $this->app->singleton('mailer', function ($app) {
            return $app->loadComponent('mail', 'Illuminate\Mail\MailServiceProvider', 'mailer');
        });

        $this->app->alias('mailer', \Illuminate\Contracts\Mail\Mailer::class);
    }
}
