<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEquipmentTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('equipment', function ($table) {
            $table->increments('id');
            $table->string('serial_number')->unique();
            $table->string('type')->nullable();
            $table->string('code')->nullable();
            $table->string('series')->nullable();
            $table->string('sub_division')->nullable();
            $table->string('fleet_number')->nullable();
            $table->string('company')->nullable();
            $table->string('operator')->nullable();
            $table->string('contact_person')->nullable();
            $table->string('location')->nullable();
            $table->string('running_hours')->nullable();
            $table->string('running_hours_date')->nullable();
            $table->string('warranty_duration')->nullable();
            $table->string('warranty_hours')->nullable();
            $table->string('warranty_start_date')->nullable();
            $table->string('under_warranty')->nullable();
            $table->string('status')->nullable();
            $table->date('last_job_date')->nullable();
            $table->string('attendance_frequency')->nullable();
            $table->string('outstanding_issues')->nullable();
            $table->string('planned_jobs')->nullable();
            $table->string('engine_make')->nullable();
            $table->string('engine_model')->nullable();
            $table->string('engine_power')->nullable();
            $table->string('engine_serial')->nullable();
            $table->string('software')->nullable();
            $table->string('software_version')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('equipment');
    }
}
