<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTableCompanies extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('companies', function (Blueprint $table) {
            $table->increments('id');
            $table->string('company_name')->unique();
            $table->string('reference')->nullable();
            $table->string('industry');
            $table->string('liebherr_client');
            $table->string('office_type');
            $table->string('country');
            $table->string('state');
            $table->string('street');
            $table->string('city');
            $table->string('area')->nullable();
            $table->string('office_function')->nullable();
            $table->string('building_no');
            $table->string('email')->unique();
            $table->string('email2')->unique()->nullable();
            $table->string('mobile');
            $table->string('mobile2')->nullable();
            $table->string('landline')->nullable();
            $table->string('landline2')->nullable();
            $table->string('fax')->nullable();
            $table->string('website')->nullable();
            $table->string('prefered_comm')->nullable();
            $table->string('spare_part_provider')->nullable();
            $table->string('account_handler_division')->nullable();
            $table->string('account_handler_person')->nullable();
            $table->string('account_handler_sales')->nullable();
            $table->string('account_handler_department')->nullable();
            $table->string('divisions_involved')->nullable();
            $table->string('status');
            $table->string('service_contract')->nullable();
            $table->string('payment_history')->nullable();
            $table->string('credit_terms')->nullable();
            $table->string('credit_limit')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('companies');
    }
}
