<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTimesheetItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('timesheet_items', function (Blueprint $table) {
            $table->increments('id');
            $table->string('day_name');
            $table->integer('day');
            $table->string('month');
            $table->string('year');
            $table->string('work_from');
            $table->string('work_to');
            $table->string('type')->nullable();
            $table->string('public_holiday')->nullable();
            $table->string('break_from')->nullable();
            $table->string('break_to')->nullable();
            $table->string('departure')->nullable();
            $table->string('arrival')->nullable();
            $table->string('travelling_from')->nullable();
            $table->string('travelling_to')->nullable();
            $table->string('land')->nullable();
            $table->integer('request_id')->unsigned()->foreign()
                ->references('id')->on('requests')->onDelete('cascade');
            $table->integer('user_id')->unsigned()->foreign()
                ->references('id')->on('users')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('timesheet_items');
    }
}
