<?php

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RolesAndPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Reset cached roles and permissions
        app()['cache']->forget('spatie.permission.cache');

        // create all permissions for companies
        Permission::create(['name' => 'company_summary']);
        Permission::create(['name' => 'company_contact_details']);
        Permission::create(['name' => 'company_contact_person']);
        Permission::create(['name' => 'company_equipment']);
        Permission::create(['name' => 'company_jobs']);
        Permission::create(['name' => 'company_spare_parts']);
        Permission::create(['name' => 'company_invoices']);
        Permission::create(['name' => 'company_financial_details']);
        Permission::create(['name' => 'company_sites']);
        Permission::create(['name' => 'company_notes']);

        // create all permissions for contact person
        Permission::create(['name' => 'contact_person_summary']);
        Permission::create(['name' => 'contact_person_contact_details']);

        //create all permissions for equipment
        Permission::create(['name' => 'equipment_summary']);
        Permission::create(['name' => 'equipment_issues']);
        Permission::create(['name' => 'equipment_jobs']);
        Permission::create(['name' => 'equipment_planned_jobs']);
        Permission::create(['name' => 'equipment_spare_parts']);
        Permission::create(['name' => 'equipment_attachments']);
        Permission::create(['name' => 'equipment_warranty']);
        Permission::create(['name' => 'equipment_machine_info']);
        Permission::create(['name' => 'equipment_note']);

        //create all permissions for users
        Permission::create(['name' => 'view_users']);
        Permission::create(['name' => 'create_user']);
        Permission::create(['name' => 'activate_user']);
        Permission::create(['name' => 'deactivate_user']);

        // create admin role and assign existing permissions
        $role = Role::create(['name' => 'administrator']);
        $role->givePermissionTo('company_summary');
        $role->givePermissionTo('company_contact_details');
        $role->givePermissionTo('company_contact_person');
        $role->givePermissionTo('company_equipment');
        $role->givePermissionTo('company_jobs');
        $role->givePermissionTo('company_spare_parts');
        $role->givePermissionTo('company_invoices');
        $role->givePermissionTo('company_financial_details');
        $role->givePermissionTo('company_sites');
        $role->givePermissionTo('company_notes');
        $role->givePermissionTo('contact_person_summary');
        $role->givePermissionTo('contact_person_contact_details');
        $role->givePermissionTo('equipment_summary');
        $role->givePermissionTo('equipment_issues');
        $role->givePermissionTo('equipment_jobs');
        $role->givePermissionTo('equipment_planned_jobs');
        $role->givePermissionTo('equipment_spare_parts');
        $role->givePermissionTo('equipment_attachments');
        $role->givePermissionTo('equipment_warranty');
        $role->givePermissionTo('equipment_machine_info');
        $role->givePermissionTo('equipment_note');
        $role->givePermissionTo('view_users');
        $role->givePermissionTo('create_user');
        $role->givePermissionTo('activate_user');
        $role->givePermissionTo('deactivate_user');
                
        //create manager role and assign existing permission
        $role = Role::create(['name' => 'manager']);
        $role->givePermissionTo('company_summary');
        $role->givePermissionTo('company_contact_details');
        $role->givePermissionTo('company_contact_person');
        $role->givePermissionTo('company_equipment');
        $role->givePermissionTo('company_jobs');
        $role->givePermissionTo('company_spare_parts');
        $role->givePermissionTo('company_invoices');
        $role->givePermissionTo('company_financial_details');
        $role->givePermissionTo('company_sites');
        $role->givePermissionTo('company_notes');
        $role->givePermissionTo('contact_person_summary');
        $role->givePermissionTo('contact_person_contact_details');
        $role->givePermissionTo('equipment_summary');
        $role->givePermissionTo('equipment_issues');
        $role->givePermissionTo('equipment_jobs');
        $role->givePermissionTo('equipment_planned_jobs');
        $role->givePermissionTo('equipment_spare_parts');
        $role->givePermissionTo('equipment_attachments');
        $role->givePermissionTo('equipment_warranty');
        $role->givePermissionTo('equipment_machine_info');
        $role->givePermissionTo('equipment_note');
        $role->givePermissionTo('view_users');

        //create role for user and assign existing permission
        $role = Role::create(['name' => 'user']);
        $role->givePermissionTo('company_summary');
        $role->givePermissionTo('company_contact_details');
        $role->givePermissionTo('company_contact_person');
        $role->givePermissionTo('company_equipment');
        $role->givePermissionTo('company_jobs');
        $role->givePermissionTo('company_spare_parts');
        $role->givePermissionTo('company_sites');
        $role->givePermissionTo('company_notes');
        $role->givePermissionTo('contact_person_summary');
        $role->givePermissionTo('contact_person_contact_details');
        $role->givePermissionTo('equipment_summary');
        $role->givePermissionTo('equipment_jobs');
        $role->givePermissionTo('equipment_planned_jobs');
        $role->givePermissionTo('equipment_spare_parts');
        $role->givePermissionTo('equipment_attachments');
        $role->givePermissionTo('equipment_warranty');
        $role->givePermissionTo('equipment_machine_info');
        $role->givePermissionTo('equipment_note');

        //create role for visitor and assign existing permission
        $role = Role::create(['name' => 'visitor']);
        $role->givePermissionTo('company_summary');
        $role->givePermissionTo('company_contact_details');
        $role->givePermissionTo('company_contact_person');
        $role->givePermissionTo('company_equipment');
        $role->givePermissionTo('company_jobs');
        $role->givePermissionTo('company_spare_parts');
        $role->givePermissionTo('company_sites');
        $role->givePermissionTo('company_notes');
        $role->givePermissionTo('contact_person_summary');
        $role->givePermissionTo('contact_person_contact_details');
        $role->givePermissionTo('equipment_summary');
    }
}
