<?php
$router->get('/', function(){
    Log::info('Test Logger');
    return "Optimus API Server";
});
$router->get('/key', function () {
    return str_random(32);
});

$router->get('/download-report', function () {
    return response()->download(base_path('public').'/issue_report.pdf');
});

$router->group(['prefix' => 'api/v1'], function ($router) {
    $router->post('login', 'UsersController@login');
    $router->post('register', 'UsersController@register');
});

$router->group(['prefix' => 'api/v1'], function ($router) {

    //    Companies
    $router->group(['prefix' => 'companies'], function ($router) {
        $router->get('/check-contact/{contactId}', 'CompaniesController@checkContactExist');
        $router->get('/check-equipment/{equipmentId}', 'CompaniesController@checkEquipmentExist');
        $router->get('/', 'CompaniesController@index');
        $router->get('/get-companies', 'CompaniesController@getCompanies');
        $router->get('/{id}', 'CompaniesController@show');
        $router->get('/{id}/jobs', 'CompaniesController@CompanyJobs');
        $router->get('/{id}/sites', 'CompaniesController@CompanySites');
        $router->post('/{id}/site', 'CompaniesController@createSite');
        $router->delete('/{id}/sites/{siteId}', 'CompaniesController@deleteSite');
        $router->post('/{id}/note', 'CompaniesController@createNote');
        $router->get('/{id}/notes', 'CompaniesController@fetchNotes');
        $router->delete('/note/{id}', 'CompaniesController@deleteNote');
        $router->post('/{id}/assign-equipment/{equipmentId}', 'CompaniesController@assignEquipment');
        $router->post('/{id}/unassign-equipment/{equipmentId}', 'CompaniesController@unassignEquipment');
        $router->post('/{id}/assign-contact/{contacttId}/{force}', 'CompaniesController@assignContact');
        $router->get('/{id}/assigned-equipments', 'CompaniesController@assignedEquipments');
        $router->get('/{id}/assigned-contacts', 'CompaniesController@assignedContacts');
        $router->delete('/{id}/unassigned-contact/{contacttId}', 'CompaniesController@unassignedContact');
        $router->post('/', 'CompaniesController@create');
        $router->put('/{id}', 'CompaniesController@update');
        $router->delete('/{id}', 'CompaniesController@delete');
    });

    //    Equipments
    $router->group(['prefix' => 'equipments'], function ($router) {
        $router->get('/', 'EquipmentsController@index');
        $router->post('/', 'EquipmentsController@create');
        $router->get('/get-equipments', 'EquipmentsController@getEquipments');
        $router->get('/{id}', 'EquipmentsController@show');
        $router->get('/{id}/jobs', 'EquipmentsController@equipmentJobs');
        $router->put('/{id}', 'EquipmentsController@update');
        $router->delete('/{id}', 'EquipmentsController@delete');
        $router->post('/{id}/note', 'EquipmentsController@createNote');
        $router->get('/{id}/notes', 'EquipmentsController@fetchNotes');
        $router->delete('/note/{id}', 'EquipmentsController@deleteNote');
    });

    //    Contact People
    $router->group(['prefix' => 'contact-people'], function ($router) {
        $router->get('/', 'ContactPeopleController@index');
        $router->get('/get-contacts', 'ContactPeopleController@getContacts');
        $router->get('/{id}', 'ContactPeopleController@show');
        $router->post('/', 'ContactPeopleController@create');
        $router->put('/{id}', 'ContactPeopleController@update');
        $router->delete('/{id}', 'ContactPeopleController@delete');
    });

    //    Users
    $router->group(['prefix' => 'users'], function ($router) {
        $router->get('/', 'UsersController@index');
        $router->get('/setup', 'UsersController@setup');
        $router->get('/roles', 'UsersController@getRoles');
        $router->get('/{id}', 'UsersController@show');
        $router->get('/{id}/profile', 'UsersController@profile');
        $router->post('/{id}/profile', 'UsersController@updateProfile');
        $router->post('/{id}/certificate', 'UsersController@addCertificate');
        $router->delete('/certificate/{id}', 'UsersController@deleteCertificate');
        $router->post('/', 'UsersController@register');
        $router->post('/change-password', 'UsersController@changePassword');
        $router->put('/{id}', 'UsersController@update');
        $router->delete('/{id}', 'UsersController@delete');
        $router->post('/{id}/activate', 'UsersController@activate');
        $router->post('/{id}/deactivate', 'UsersController@deactivate');
        //
        $router->put('/{id}/hours_report/hours_rep_desc', 'HoursReportController@hours_report_desc');
        // hours report
        $router->get('/{id}/hours_report', 'HoursReportController@get_hours_report');
        // time sheet
        $router->get('/{id}/hours_report/timesheet', 'HoursReportTimesheetController@index');
        $router->post('/{id}/hours_report/timesheet', 'HoursReportTimesheetController@store');
        $router->get('/{id}/hours_report/timesheet/{sheetId}', 'HoursReportTimesheetController@show');
        $router->put('/{id}/hours_report/timesheet/{sheetId}', 'HoursReportTimesheetController@update');
        $router->delete('/{id}/hours_report/timesheet/{sheetId}', 'HoursReportTimesheetController@destory');
        // expenses
        $router->get('/{id}/hours_report/expenses', 'HoursReportExpensesController@index');
        $router->post('/{id}/hours_report/expenses', 'HoursReportExpensesController@store');
        $router->get('/{id}/hours_report/expenses/{expId}', 'HoursReportExpensesController@show');
        $router->put('/{id}/hours_report/expenses/{expId}', 'HoursReportExpensesController@update');
        $router->delete('/{id}/hours_report/expenses/{expId}', 'HoursReportExpensesController@destroy');
    });

    $router->group(['prefix' => 'sites'], function ($router) {
        $router->get('/', 'SitesController@index');
    });

    // Request.
    $router->group(['prefix' => 'requests'], function($router){
        $router->get('/', 'RequestController@index');
        $router->post('/', 'RequestController@createRequest');
        $router->get('/serial/{serialNo}', 'RequestController@latestRequest');
        $router->get('/{serialNo}/jobs', 'RequestController@getJobs');
        $router->get('/{serialNo}/att_frq', 'RequestController@attendanceFrequency');
        $router->put('/{id}', 'RequestController@updateRequest');
        $router->get('/{id}/engr/{engID}/hours_report', 'RequestController@hours_report');
        $router->get('/{id}/engr/{engID}/issue_report', 'RequestController@issue_report');
        $router->delete('/{id}', 'RequestController@destroy');

        // Hours Report
        $router->post('/{req_id}/expenses', 'RequestController@store_expenses');
        $router->post('/{req_id}/expenses/{exp_id}', 'RequestController@update_expenses');
        $router->delete('/{req_id}/expenses/{exp_id}', 'RequestController@delete_expenses');

        $router->post('/{req_id}/timesheet', 'RequestController@store_timesheet');
        $router->post('/{req_id}/timesheet/{timesheet_id}', 'RequestController@update_timesheet');
        $router->delete('/{req_id}/timesheet/{timesheet_id}', 'RequestController@delete_timesheet');

        $router->post('/{reqId}/hours_report', 'HoursReportController@store');
    });

    // Hours Report
    $router->group(['prefix' => 'hours_report'], function($router){
        $router->post('/{repId}/expenses', 'JobExpensesController@store');
        $router->post('/{id}/hours_rep_desc', 'HoursReportDescController@store');
        $router->post('/{id}/timesheet', 'TimesheetController@store');
        $router->post('/{id}/issue_report', 'HoursReportController@issue_report');
    });

    $router->group(['prefix' => 'expenses'], function($router){
        $router->post('/{id}/expenses_item', 'JobExpensesItemsController@store');
    });

    $router->group(['prefix' => 'timesheet'], function($router){
        $router->post('/{id}/timesheet_item', 'TimesheetItemsController@store');
    });

    $router->group(['prefix' => 'profiles'], function ($router) {
        $router->get('/', 'ProfilesController@index');
        $router->get('/engineers', 'ProfilesController@getEngineers');
    });
});
